% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_helpers.R
\name{tof_find_cv_predictions}
\alias{tof_find_cv_predictions}
\title{Calculate and store the predicted outcomes for each validation set observation during model tuning}
\usage{
tof_find_cv_predictions(
  split_data,
  prepped_recipe,
  lambda,
  alpha,
  model_type,
  outcome_colnames
)
}
\arguments{
\item{split_data}{An `rsplit` object from the \code{\link[rsample]{rsample}}
package.
Alternatively, an unsplit tbl_df can be provided, though this is not recommended.}

\item{prepped_recipe}{A trained \code{\link[recipes]{recipe}}}

\item{lambda}{A single numeric value indicating which penalty (lambda) value
should be used to make the predictions}

\item{alpha}{A single numeric value indicating which mixture (alpha) value
should be used to make the predictions}

\item{model_type}{A string indicating which kind of elastic net model to build.
If a continuous response is being predicted, use "linear" for linear regression;
if a categorical response with only 2 classes is being predicted, use
"two-class" for logistic regression; if a categorical response with more than 2
levels is being predicted, use "multiclass" for multinomial regression; and if
a time-to-event outcome is being predicted, use "survival" for Cox regression.}

\item{outcome_colnames}{Quoted column names indicating which columns in the data
being fit represent the outcome variables (with all others assumed to be predictors).}
}
\value{
A tibble containing the predicted and true values for the outcome
for each of the validation observations in `split_data`.
}
\description{
Calculate and store the predicted outcomes for each validation set observation during model tuning
}
