% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{tof_extract_threshold}
\alias{tof_extract_threshold}
\title{Extract aggregated features from CyTOF data using a binary threshold}
\usage{
tof_extract_threshold(
  tof_tibble,
  cluster_col,
  group_cols = NULL,
  marker_cols = where(tof_is_numeric),
  stimulation_col = NULL,
  threshold = asinh(10/5),
  format = c("wide", "long")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids of the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{group_cols}{Unquoted column names representing which columns in `tof_tibble`
should be used to break the rows of `tof_tibble` into subgroups for the feature
extraction calculation. Defaults to NULL (i.e. performing the extraction without subgroups).}

\item{marker_cols}{Unquoted column names representing which columns in `tof_tibble`
(i.e. which CyTOF protein measurements) should be included in the feature extraction
calculation. Defaults to all numeric (integer or double) columns.
Supports tidyselect helpers.}

\item{stimulation_col}{Optional. An unquoted column name that indicates which
column in `tof_tibble` contains information about which stimulation condition each cell
was exposed to during data acquisition. If provided, the feature extraction will be
further broken down into subgroups by stimulation condition (and features from each stimulation
condition will be included as their own features in wide format).}

\item{threshold}{A double or integer of length 1 indicating what threshold should be used.}

\item{format}{A string indicating if the data should be returned in "wide" format
(the default; each cluster feature is given its own column) or in "long" format
(each cluster feature is provided as its own row).}
}
\value{
A tibble.

If format == "wide", the tibble will have 1 row for each combination of
the grouping variables provided in `group_cols` and one column for each grouping variable,
one column for each extracted feature (the proportion of cells in a given cluster
over with marker expression values over `threshold`).
The names of each column containing cluster features is obtained using the following pattern:
"\{marker_id\}@\{cluster_id\}_threshold".

If format == "long", the tibble will have 1 row for each combination of the grouping variables
in `group_cols`, each cluster id (i.e. level) in `cluster_col`, and each marker in `marker_cols`.
It will have one column for each grouping variable, one column for the cluster ids, one
column for the CyTOF channel names, and one column (`value`) containing the features.
}
\description{
This feature extraction function calculates the proportion of cells in a given cluster
that have a CyTOF antigen expression over a user-specified threshold across a
user-specified selection of CyTOF markers. These calculations can be done either
overall (across all cells in the dataset) or after breaking down the cells into
subgroups using `group_cols`.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE),
        patient = sample(c("kirby", "mario"), size = 1000, replace = TRUE),
        stim = sample(c("basal", "stim"), size = 1000, replace = TRUE)
    )

# extract proportion of each cluster in each patient in wide format
tof_extract_threshold(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    group_cols = patient
)

# extract proportion of each cluster in each patient in long format
tof_extract_threshold(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    group_cols = patient,
    format = "long"
)

}
\seealso{
Other feature extraction functions: 
\code{\link{tof_extract_central_tendency}()},
\code{\link{tof_extract_emd}()},
\code{\link{tof_extract_features}()},
\code{\link{tof_extract_jsd}()},
\code{\link{tof_extract_proportion}()}
}
\concept{feature extraction functions}
