% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{tof_extract_proportion}
\alias{tof_extract_proportion}
\title{Extract the proportion of cells in each cluster in a `tof_tibble`.}
\usage{
tof_extract_proportion(
  tof_tibble,
  cluster_col,
  group_cols = NULL,
  format = c("wide", "long")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids of the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{group_cols}{Unquoted column names representing which columns in `tof_tibble`
should be used to break the rows of `tof_tibble` into subgroups for the feature
extraction calculation. Defaults to NULL (i.e. performing the extraction without subgroups).}

\item{format}{A string indicating if the data should be returned in "wide" format
(the default; each cluster proportion is given its own column) or in "long" format
(each cluster proportion is provided as its own row).}
}
\value{
A tibble.

If format == "wide", the tibble will have 1 row for each combination of
the grouping variables provided in `group_cols` and one column for each grouping variable
as well as one column for the proportion of cells in each cluster. The names of each
column containing cluster proportions is obtained using the following pattern:
"prop@\{cluster_id\}".

If format == "long", the tibble will have 1 row for each combination of the grouping variables
in `group_cols` and each cluster id (i.e. level) in `cluster_col`. It will have one column for
each grouping variable, one column for the cluster ids, and one column (`prop`) containing the
cluster proportions.
}
\description{
This feature extraction function allows you to calculate the proportion of
cells in each cluster in a `tof_tibble` - either overall or when broken down
into subgroups using `group_cols`.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE),
        patient = sample(c("kirby", "mario"), size = 1000, replace = TRUE),
        stim = sample(c("basal", "stim"), size = 1000, replace = TRUE)
    )

# extract proportion of each cluster in each patient in wide format
tof_extract_proportion(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    group_cols = patient
)

# extract proportion of each cluster in each patient in long format
tof_extract_proportion(
    tof_tibble = sim_data,
    cluster_col = cluster_id,
    group_cols = patient,
    format = "long"
)

}
\seealso{
Other feature extraction functions: 
\code{\link{tof_extract_central_tendency}()},
\code{\link{tof_extract_emd}()},
\code{\link{tof_extract_features}()},
\code{\link{tof_extract_jsd}()},
\code{\link{tof_extract_threshold}()}
}
\concept{feature extraction functions}
