% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tof_estimate_density}
\alias{tof_estimate_density}
\title{Estimate the local densities for all cells in a high-dimensional cytometry dataset.}
\usage{
tof_estimate_density(
  tof_tibble,
  distance_cols = where(tof_is_numeric),
  distance_function = c("euclidean", "cosine", "l2", "ip"),
  normalize = TRUE,
  ...,
  augment = TRUE,
  method = c("mean_distance", "sum_distance", "spade")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{distance_cols}{Unquoted names of the columns in `tof_tibble` to use in
calculating cell-to-cell distances during the local density estimation for
each cell. Defaults to all numeric columns in `tof_tibble`.}

\item{distance_function}{A string indicating which distance function to use
for calculating cell-to-cell distances during local density estimation. Options
include "euclidean" (the default) and "cosine".}

\item{normalize}{A boolean value indicating if the vector of local density
estimates should be normalized to values between 0 and 1. Defaults to TRUE.}

\item{...}{Additional arguments to pass to the `tof_*_density()` function family
member corresponding to the chosen `method`.}

\item{augment}{A boolean value indicating if the output should column-bind the
local density estimates of each cell as a new column in `tof_tibble` (TRUE; the default) or if
a single-column tibble including only the local density estimates should be returned (FALSE).}

\item{method}{A string indicating which local density estimation method should be used.
Valid values include "mean_distance", "sum_distance", and "spade".}
}
\value{
A `tof_tbl` or `tibble` If augment = FALSE, it will have a single column encoding
the local density estimates for each cell in `tof_tibble`. If augment = TRUE, it will have
ncol(tof_tibble) + 1 columns: each of the (unaltered) columns in `tof_tibble`
plus an additional column encoding the local density estimates.
}
\description{
This function is a wrapper around tidytof's tof_*_density() function family.
It performs local density estimation on high-dimensional cytometry data using a user-specified
method (of 3 choices) and each method's corresponding input parameters.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000)
    )

# perform the density estimation
tof_estimate_density(tof_tibble = sim_data, method = "spade")

# perform the density estimation with a smaller search radius around
# each cell
tof_estimate_density(
    tof_tibble = sim_data,
    alpha_multiplier = 2,
    method = "spade"
)

}
\seealso{
Other local density estimation functions: 
\code{\link{tof_knn_density}()},
\code{\link{tof_spade_density}()}
}
\concept{local density estimation functions}
