% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampling.R
\name{tof_downsample_prop}
\alias{tof_downsample_prop}
\title{Downsample high-dimensional cytometry data by randomly selecting a proportion of the cells in each group.}
\usage{
tof_downsample_prop(tof_tibble, group_cols = NULL, prop_cells)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{group_cols}{Unquoted names of the columns in `tof_tibble` that should
be used to define groups from which `prop_cells` will be downsampled.
Supports tidyselect helpers. Defaults to `NULL` (no grouping).}

\item{prop_cells}{A proportion of cells (between 0 and 1) that should be sampled
from each group defined by `group_cols`.}
}
\value{
A `tof_tbl` with the same number of columns as the input `tof_tibble`,
but fewer rows. Specifically, the number of rows should be `prop_cells` times the
number of rows in the input `tof_tibble`.
}
\description{
This function downsamples the number of cells in a `tof_tbl` by randomly selecting
a `prop_cells` proportion of the total number of cells with each unique combination
of values in `group_cols`.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

# sample 10\% of all cells from the input data
tof_downsample_prop(
    tof_tibble = sim_data,
    prop_cells = 0.1
)

# sample 10\% of all cells from each cluster in the input data
tof_downsample_prop(
    tof_tibble = sim_data,
    group_cols = cluster_id,
    prop_cells = 0.1
)

}
\seealso{
Other downsampling functions: 
\code{\link{tof_downsample}()},
\code{\link{tof_downsample_constant}()},
\code{\link{tof_downsample_density}()}
}
\concept{downsampling functions}
