% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampling.R
\name{tof_downsample_constant}
\alias{tof_downsample_constant}
\title{Downsample high-dimensional cytometry data by randomly selecting a constant number of cells per group.}
\usage{
tof_downsample_constant(tof_tibble, group_cols = NULL, num_cells)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{group_cols}{Unquoted names of the columns in `tof_tibble` that should
be used to define groups from which `num_cells` will be downsampled.
Supports tidyselect helpers. Defaults to `NULL` (no grouping).}

\item{num_cells}{An integer number of cells that should be sampled from each
group defined by `group_cols`.}
}
\value{
A `tof_tbl` with the same number of columns as the input `tof_tibble`,
but fewer rows. Specifically, the number of rows will be `num_cells` multiplied
by the number of unique combinations of the values in `group_cols`. If any group
has fewer than `num_cells` number of cells, all cells from that group will be
kept.
}
\description{
This function downsamples the number of cells in a `tof_tbl` by randomly selecting
`num_cells` cells from each unique combination of values in `group_cols`.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

# sample 500 cells from the input data
tof_downsample_constant(
    tof_tibble = sim_data,
    num_cells = 500L
)

# sample 20 cells per cluster from the input data
tof_downsample_constant(
    tof_tibble = sim_data,
    group_cols = cluster_id,
    num_cells = 20L
)

}
\seealso{
Other downsampling functions: 
\code{\link{tof_downsample}()},
\code{\link{tof_downsample_density}()},
\code{\link{tof_downsample_prop}()}
}
\concept{downsampling functions}
