% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampling.R
\name{tof_downsample}
\alias{tof_downsample}
\title{Downsample high-dimensional cytometry data.}
\usage{
tof_downsample(
  tof_tibble,
  group_cols = NULL,
  ...,
  method = c("constant", "prop", "density")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{group_cols}{Unquoted names of the columns in `tof_tibble` that should
be used to define groups within which the downsampling will be performed.
Supports tidyselect helpers. Defaults to `NULL` (no grouping).}

\item{...}{Additional arguments to pass to the `tof_downsample_*` function
family member corresponding to the chosen method.}

\item{method}{A string indicating which downsampling method to use: "constant"
(the default), "prop", or "density".}
}
\value{
A downsampled `tof_tbl` with the same number of columns as the input
`tof_tibble`, but fewer rows. The number of rows in the result will depend
on the chosen downsampling method.
}
\description{
This function downsamples the number of cells in a `tof_tbl` using the
one of three methods (randomly sampling a constant number of cells,
randomly sampling a proportion of cells, or performing density-dependent
downsampling per the algorithm in
\href{https://pubmed.ncbi.nlm.nih.gov/21964415/}{Qiu et al., (2011)}).
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000),
        cluster_id = sample(letters, size = 1000, replace = TRUE)
    )

# sample 200 cells from the input data
tof_downsample(
    tof_tibble = sim_data,
    num_cells = 200L,
    method = "constant"
)

# sample 10\% of all cells from the input data
tof_downsample(
    tof_tibble = sim_data,
    prop_cells = 0.1,
    method = "prop"
)

# sample ~10\% of cells from the input data using density dependence
tof_downsample(
    tof_tibble = sim_data,
    target_prop_cells = 0.1,
    method = "density"
)

}
\seealso{
Other downsampling functions: 
\code{\link{tof_downsample_constant}()},
\code{\link{tof_downsample_density}()},
\code{\link{tof_downsample_prop}()}
}
\concept{downsampling functions}
