% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patient-level_modeling.R
\name{tof_create_grid}
\alias{tof_create_grid}
\title{Create an elastic net hyperparameter search grid of a specified size}
\usage{
tof_create_grid(
  penalty_values,
  mixture_values,
  num_penalty_values = 5,
  num_mixture_values = 5
)
}
\arguments{
\item{penalty_values}{A numeric vector of the unique elastic net penalty values ("lambda")
to include in the
hyperparameter grid. If unspecified, a regular grid with `num_penalty_values` between
10^(-10) and 10^(0) will be used.}

\item{mixture_values}{A numeric vector of all elastic net mixture values ("alpha") to include in the
hyperparameter grid. If unspecified, a regular grid with `num_mixture_values` between
0 and 1 will be used.}

\item{num_penalty_values}{Optional. If `penalty_values` is not supplied, `num_penalty_values`
(an integer) can be given to specify how many equally-spaced penalty values between
10^(-10) and 1 should be included in the hyperparameter grid. If this method is used,
the regular grid will always be returned. Defaults to 5.}

\item{num_mixture_values}{Optional. If `mixture_values` is not supplied, `num_mixture_values`
(an integer) can be given to specify how many equally-spaced penalty values between
0 (ridge regression) and 1 (lasso) should be included in the hyperparameter grid. If this method is used,
the regular grid will always be returned. Defaults to 5.}
}
\value{
A tibble with two numeric columns: `penalty` and `mixture`.
}
\description{
This function creates a regular hyperparameter search grid (in the form of a
\code{\link[dplyr]{tibble}}) specifying the search space for the two
hyperparameters of a generalized linear model using the glmnet package:
the regularization penalty term
and the lasso/ridge regression mixture term.
}
\examples{
tof_create_grid()

tof_create_grid(num_penalty_values = 10, num_mixture_values = 5)

tof_create_grid(penalty_values = c(0.01, 0.1, 0.5))

}
\seealso{
Other modeling functions: 
\code{\link{tof_assess_model}()},
\code{\link{tof_predict}()},
\code{\link{tof_split_data}()},
\code{\link{tof_train_model}()}
}
\concept{modeling functions}
