% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster_tibble}
\alias{tof_cluster_tibble}
\title{Cluster (ungrouped) high-dimensional cytometry data.}
\usage{
tof_cluster_tibble(tof_tibble, ..., augment = TRUE, method)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{...}{Additional arguments to pass to the `tof_cluster_*`
function family member corresponding to the chosen method.}

\item{augment}{A boolean value indicating if the output should column-bind the
cluster ids of each cell as a new column in `tof_tibble` (TRUE, the default) or if
a single-column tibble including only the cluster ids should be returned (FALSE).}

\item{method}{A string indicating which clustering methods should be used. Valid
values include "flowsom", "phenograph", "kmeans", "ddpr", and "xshift".}
}
\value{
A `tof_tbl` or `tibble` If augment = FALSE, it will have a single column encoding
the cluster ids for each cell in `tof_tibble`. If augment = TRUE, it will have
ncol(tof_tibble) + 1 columns: each of the (unaltered) columns in `tof_tibble`
plus an additional column encoding the cluster ids.
}
\description{
This function is a wrapper around tidytof's tof_cluster_* function family and
provides a low-level API for clustering ungrouped data frames. It is a subroutine
of tof_cluster and shouldn't be called directly by users.
}
