% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster_phenograph}
\alias{tof_cluster_phenograph}
\title{Perform PhenoGraph clustering on high-dimensional cytometry data.}
\usage{
tof_cluster_phenograph(
  tof_tibble,
  cluster_cols = where(tof_is_numeric),
  num_neighbors = 30,
  distance_function = c("euclidean", "cosine"),
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_cols}{Unquoted column names indicating which columns in `tof_tibble` to
use in computing the PhenoGraph clusters. Defaults to all numeric columns
in `tof_tibble`. Supports tidyselect helpers.}

\item{num_neighbors}{An integer indicating the number of neighbors to use when
constructing PhenoGraph's k-nearest-neighbor graph. Smaller values emphasize
local graph structure; larger values emphasize global graph structure (and
will add time to the computation). Defaults to 30.}

\item{distance_function}{A string indicating which distance function to use
for the nearest-neighbor calculation. Options include "euclidean"
(the default) and "cosine" distances.}

\item{...}{Optional additional parameters that can be passed to
\code{\link{tof_find_knn}}.}
}
\value{
A tibble with one column named `.phenograph_cluster`. This column will contain an
integer vector of length `nrow(tof_tibble)` indicating the id of
the PhenoGraph cluster to which each cell (i.e. each row) in `tof_tibble` was assigned.
}
\description{
This function performs PhenoGraph clustering on high-dimensional cytometry data using a user-specified
selection of input variables/high-dimensional cytometry measurements.
}
\details{
For additional details about the Phenograph algorithm,
see \href{https://pubmed.ncbi.nlm.nih.gov/26095251/}{this paper}.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000)
    )
tof_cluster_phenograph(tof_tibble = sim_data)
tof_cluster_phenograph(tof_tibble = sim_data, cluster_cols = c(cd45, cd19))

}
\seealso{
Other clustering functions: 
\code{\link{tof_cluster}()},
\code{\link{tof_cluster_ddpr}()},
\code{\link{tof_cluster_flowsom}()},
\code{\link{tof_cluster_kmeans}()}
}
\concept{clustering functions}
