% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster_kmeans}
\alias{tof_cluster_kmeans}
\title{Perform k-means clustering on high-dimensional cytometry data.}
\usage{
tof_cluster_kmeans(
  tof_tibble,
  cluster_cols = where(tof_is_numeric),
  num_clusters = 20,
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tibble`.}

\item{cluster_cols}{Unquoted column names indicating which columns in `tof_tibble` to
use in computing the k-means clusters. Defaults to all numeric columns
in `tof_tibble`. Supports tidyselect helpers.}

\item{num_clusters}{An integer indicating the maximum number of clusters
that should be returned. Defaults to 20.}

\item{...}{Optional additional arguments that can be passed to
\code{\link[stats]{kmeans}}.}
}
\value{
A tibble with one column named `.kmeans_cluster`. This column will contain an
integer vector of length `nrow(tof_tibble)` indicating the id of
the k-means cluster to which each cell (i.e. each row) in `tof_tibble` was assigned.
}
\description{
This function performs k-means clustering on high-dimensional cytometry data using a user-specified
selection of input variables/high-dimensional cytometry measurements. It is mostly a convenient
wrapper around \code{\link[stats]{kmeans}}.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = rnorm(n = 1000),
        cd34 = rnorm(n = 1000),
        cd19 = rnorm(n = 1000)
    )
tof_cluster_kmeans(tof_tibble = sim_data)
tof_cluster_kmeans(tof_tibble = sim_data, cluster_cols = c(cd45, cd19))

}
\seealso{
Other clustering functions: 
\code{\link{tof_cluster}()},
\code{\link{tof_cluster_ddpr}()},
\code{\link{tof_cluster_flowsom}()},
\code{\link{tof_cluster_phenograph}()}
}
\concept{clustering functions}
