% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster_grouped}
\alias{tof_cluster_grouped}
\title{Cluster (grouped) high-dimensional cytometry data.}
\usage{
tof_cluster_grouped(tof_tibble, group_cols, ..., augment = TRUE, method)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{group_cols}{An unquoted column name indicating which columns
should be used to group cells before clustering. Clustering is then performed
on each group independently.}

\item{...}{Additional arguments to pass to the `tof_cluster_*`
function family member corresponding to the chosen method.}

\item{augment}{A boolean value indicating if the output should column-bind the
cluster ids of each cell as a new column in `tof_tibble` (TRUE, the default) or if
a single-column tibble including only the cluster ids should be returned (FALSE).}

\item{method}{A string indicating which clustering methods should be used. Valid
values include "flowsom", "phenograph", "kmeans", "ddpr", and "xshift".}
}
\value{
A `tof_tbl` or `tibble` If augment = FALSE, it will have a single column encoding
the cluster ids for each cell in `tof_tibble`. If augment = TRUE, it will have
ncol(tof_tibble) + 1 columns: each of the (unaltered) columns in `tof_tibble`
plus an additional column encoding the cluster ids.
}
\description{
This function is a wrapper around tidytof's tof_cluster_* function family and
provides a low-level API for clustering grouped data frames. It is a subroutine
of tof_cluster and shouldn't be called directly by users.
}
