% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster_flowsom}
\alias{tof_cluster_flowsom}
\title{Perform FlowSOM clustering on high-dimensional cytometry data}
\usage{
tof_cluster_flowsom(
  tof_tibble = NULL,
  cluster_cols = where(tof_is_numeric),
  som_xdim = 10,
  som_ydim = 10,
  som_distance_function = c("euclidean", "manhattan", "chebyshev", "cosine"),
  perform_metaclustering = TRUE,
  num_metaclusters = 20,
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_cols}{Unquoted column names indicating which columns in `tof_tibble` to
use in computing the flowSOM clusters. Defaults to all numeric columns
in `tof_tibble`. Supports tidyselect helpers.}

\item{som_xdim}{The width of the grid used by the self-organizing map. The
total number of clusters returned by FlowSOM will be som_xdim * som_ydim,
so adjust this value to affect the final number of clusters. Defaults to 10.}

\item{som_ydim}{The height of the grid used by the self-organizing map. The
total number of clusters returned by FlowSOM will be som_xdim * som_ydim,
so adjust this value to affect the final number of clusters. Defaults to 10.}

\item{som_distance_function}{The distance function used during self-organizing
map calculations. Options are "euclidean" (the default), "manhattan", "chebyshev",
and "cosine".}

\item{perform_metaclustering}{A boolean value indicating if metaclustering
should be performed on the initial clustering result returned by FlowSOM.
Defaults to TRUE.}

\item{num_metaclusters}{An integer indicating the maximum number of metaclusters
that should be returned after metaclustering. Defaults to 20.}

\item{...}{Optional additional parameters that can be passed to the \code{\link[FlowSOM]{BuildSOM}}
function.}
}
\value{
A tibble with one column named `.flowsom_cluster` or `.flowsom_metacluster`
depending on the value of `perform_metaclustering`. The column will contain an
integer vector of length `nrow(tof_tibble)` indicating the id of
the flowSOM cluster to which each cell (i.e. each row) in `tof_tibble` was assigned.
}
\description{
This function performs FlowSOM clustering on high-dimensional cytometry data using a user-specified
selection of input variables/high-dimensional cytometry measurements. It is mostly a convenient
wrapper around \code{\link[FlowSOM]{SOM}} and \code{\link[FlowSOM]{MetaClustering}}.
}
\details{
For additional details about the FlowSOM algorithm,
see \href{https://pubmed.ncbi.nlm.nih.gov/25573116/}{this paper}.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 200),
        cd38 = rnorm(n = 200),
        cd34 = rnorm(n = 200),
        cd19 = rnorm(n = 200)
    )

tof_cluster_flowsom(tof_tibble = sim_data, cluster_cols = c(cd45, cd19))

}
\seealso{
Other clustering functions: 
\code{\link{tof_cluster}()},
\code{\link{tof_cluster_ddpr}()},
\code{\link{tof_cluster_kmeans}()},
\code{\link{tof_cluster_phenograph}()}
}
\concept{clustering functions}
