% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_cluster}
\alias{tof_cluster}
\title{Cluster high-dimensional cytometry data.}
\usage{
tof_cluster(
  tof_tibble,
  cluster_cols = where(tof_is_numeric),
  group_cols = NULL,
  ...,
  augment = TRUE,
  method
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{cluster_cols}{Unquoted column names indicating which columns in `tof_tibble` to
use in computing the clusters. Defaults to all numeric columns
in `tof_tibble`. Supports tidyselect helpers.}

\item{group_cols}{Optional. Unquoted column names indicating which columns
should be used to group cells before clustering. Clustering is then performed
on each group independently. Supports tidyselect helpers.}

\item{...}{Additional arguments to pass to the `tof_cluster_*`
function family member corresponding to the chosen method.}

\item{augment}{A boolean value indicating if the output should column-bind the
cluster ids of each cell as a new column in `tof_tibble` (TRUE, the default) or if
a single-column tibble including only the cluster ids should be returned (FALSE).}

\item{method}{A string indicating which clustering methods should be used. Valid
values include "flowsom", "phenograph", "kmeans", "ddpr", and "xshift".}
}
\value{
A `tof_tbl` or `tibble` If augment = FALSE, it will have a single column encoding
the cluster ids for each cell in `tof_tibble`. If augment = TRUE, it will have
ncol(tof_tibble) + 1 columns: each of the (unaltered) columns in `tof_tibble`
plus an additional column encoding the cluster ids.
}
\description{
This function is a wrapper around tidytof's tof_cluster_* function family.
It performs clustering on high-dimensional cytometry data using a user-specified method (of 5 choices)
and each method's corresponding input parameters.
}
\examples{
sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 500),
        cd38 = rnorm(n = 500),
        cd34 = rnorm(n = 500),
        cd19 = rnorm(n = 500)
    )

tof_cluster(tof_tibble = sim_data, method = "kmeans")
tof_cluster(tof_tibble = sim_data, method = "phenograph")

}
\seealso{
Other clustering functions: 
\code{\link{tof_cluster_ddpr}()},
\code{\link{tof_cluster_flowsom}()},
\code{\link{tof_cluster_kmeans}()},
\code{\link{tof_cluster_phenograph}()}
}
\concept{clustering functions}
