% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developmental_classifier_helpers.R
\name{tof_classify_cells}
\alias{tof_classify_cells}
\title{Classify each cell (i.e. each row) in a matrix of cancer cells into its most
similar healthy developmental subpopulation.}
\usage{
tof_classify_cells(
  classifier_fit,
  cancer_data,
  distance_function = c("mahalanobis", "cosine", "pearson")
)
}
\arguments{
\item{classifier_fit}{A tibble produced by \code{\link{tof_build_classifier}}.}

\item{cancer_data}{A matrix in which each row corresponds to a cell and each
column corresponds to a measured CyTOF antigen.}

\item{distance_function}{A string indicating which of three distance functions should
be used to calculate the distances between each row of `cancer_data` and the
healthy developmental subpopulations corresponding to each row of `classifier_fit`.}
}
\value{
A data.frame in which each column represents the distance between
a cell in the input data and each healthy subpopulation cells are being
classified into.
}
\description{
This function uses a specified distance metric to classify each cell in a data.frame
or matrix (`cancer_data`) into one of `nrow(classifier_fit)` subpopulations
based on minimum distance, as described in \href{https://pubmed.ncbi.nlm.nih.gov/29505032/}{this paper}.
}
