% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling_helpers.R
\name{tof_check_model_args}
\alias{tof_check_model_args}
\title{Check argument specifications for a glmnet model.}
\usage{
tof_check_model_args(
  split_data,
  model_type = c("linear", "two-class", "multiclass", "survival"),
  best_model_type = c("best", "best with sparsity"),
  response_col,
  time_col,
  event_col
)
}
\arguments{
\item{split_data}{An `rsplit` or `rset` object from the \code{\link[rsample]{rsample}}
package containing the sample-level data to use for modeling. Alternatively,
an unsplit tbl_df can be provided, though this is not recommended.}

\item{model_type}{A string indicating which kind of elastic net model to build.
If a continuous response is being predicted, use "linear" for linear regression;
if a categorical response with only 2 classes is being predicted, use
"two-class" for logistic regression; if a categorical response with more than 2
levels is being predicted, use "multiclass" for multinomial regression; and if
a time-to-event outcome is being predicted, use "survival" for Cox regression.}

\item{best_model_type}{Currently unused.}

\item{response_col}{Unquoted column name indicating which column in the data
contained in `split_data` should be used as the outcome in a "two-class", "multiclass",
or "linear" elastic net model. Must be a factor for "two-class" and "multiclass"
models and must be a numeric for "linear" models. Ignored if `model_type` is "survival".}

\item{time_col}{Unquoted column name indicating which column in the data
contained in `split_data` represents the time-to-event outcome in a "survival"
elastic net model. Must be numeric. Ignored if `model_type` is "two-class", "multiclass",
or "linear".}

\item{event_col}{Unquoted column name indicating which column in the data
contained in `split_data` represents the time-to-event outcome in a "survival"
elastic net model. Must be a binary column - all values should be either 0 or 1
(with 1 indicating the adverse event) or FALSE and TRUE (with TRUE indicating the
adverse event). Ignored if `model_type` is "two-class", "multiclass",
or "linear".}
}
\value{
A tibble. If arguments are specified correctly, this tibble can be
used to create a recipe for preprocessing.
}
\description{
Check argument specifications for a glmnet model.
}
