% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{tof_calculate_flow_rate}
\alias{tof_calculate_flow_rate}
\title{Calculate the relative flow rates of different timepoints throughout a flow
or mass cytometry run.}
\usage{
tof_calculate_flow_rate(
  tof_tibble,
  time_col,
  num_timesteps = nrow(tof_tibble)/1000
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{time_col}{An unquoted column name indicating which column in `tof_tibble`
contains the time at which each cell was collected.}

\item{num_timesteps}{The number of bins into which `time_col` should be split.
to define "timesteps" of the data collection process. The number of cells analyzed
by the cytometer will be counted in each bin separately and will represent
the relative average flow rate for that timestep in data collection.}
}
\value{
A tibble with 3 columns and num_timesteps rows. Each row will represent a single
timestep (and an error will be thrown if `num_timesteps` is larger than the number of rows in
`tof_tibble`). The three columns are as follows: "timestep", a numeric vector indicating which
timestep is represented by a given row; "time_window", a factor showing the interval in `time_col`
over which "timestep" is defined; and "num_cells", the number of cells that were collected during
each timestep.
}
\description{
Calculate the relative flow rates of different timepoints throughout a flow
or mass cytometry run.
}
\examples{

# simulate some data
sim_data <-
    data.frame(
        cd4 = rnorm(n = 100, mean = 5, sd = 0.5),
        cd8 = rnorm(n = 100, mean = 0, sd = 0.1),
        cd33 = rnorm(n = 100, mean = 10, sd = 0.1),
        time = sample(1:300, size = 100)
    )

tof_calculate_flow_rate(tof_tibble = sim_data, time_col = time, num_timesteps = 20L)

}
