% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developmental_classifier_helpers.R
\name{tof_build_classifier}
\alias{tof_build_classifier}
\title{Calculate centroids and covariance matrices for each cell subpopulation in
healthy CyTOF data.}
\usage{
tof_build_classifier(
  healthy_tibble = NULL,
  healthy_cell_labels = NULL,
  classifier_markers = where(tof_is_numeric),
  verbose = FALSE
)
}
\arguments{
\item{healthy_tibble}{A `tibble` or `tof_tibble` containing cells from only
healthy control samples (i.e. not disease samples).}

\item{healthy_cell_labels}{A character or integer vector of length `nrow(healthy_tibble)`.
Each entry in this vector should represent the cell subpopulation label (or cluster id) for
the corresponding row in `healthy_tibble`.}

\item{classifier_markers}{Unquoted column names indicating which columns in `healthy_tibble` to
use in the developmental classification. Defaults to all numeric columns
in `healthy_tibble`. Supports tidyselect helpers.}

\item{verbose}{A boolean value indicating if updates should be printed to the
console during classification. Defaults to FALSE.}
}
\value{
A tibble with three columns:
\strong{population} (id of the healthy cell population),
\strong{centroid} (the centroid vector for that cell population), and
\strong{covariance_matrix} (the covariance matrix for that cell population)
}
\description{
This function takes a `tibble` or `tof_tibble` storing healthy cell measurements
in each of its rows and a vector (`healthy_cell_labels`) representing the
cell subpopulation to which each cell belongs. It uses these values to calculate
several values required to perform "developmental classification" as described in
\href{https://pubmed.ncbi.nlm.nih.gov/29505032/}{this paper}.
}
