% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{tof_batch_correct}
\alias{tof_batch_correct}
\title{Perform groupwise linear rescaling of high-dimensional cytometry measurements}
\usage{
tof_batch_correct(
  tof_tibble,
  channel_cols,
  group_cols,
  augment = TRUE,
  method = c("rescale", "quantile")
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{channel_cols}{Unquoted column names representing columns that contain
single-cell protein measurements. Supports tidyselect helpers.}

\item{group_cols}{Optional. Unquoted column names indicating which columns
should be used to group cells before batch correction. Batch correction is then
performed independently within each group. Supports tidyselect helpers.}

\item{augment}{A boolean value indicating if the output should replace the
`channel_cols` in `tof_tibble` with the new, batch corrected columns (TRUE, the default)
or if it should only return the batch-corrected columns (FALSE) with all other columns
omitted.}

\item{method}{A string indicating which batch correction method should be used.
Valid options are "rescale" for linear scaling (the default) and "quantile"
for quantile normalization using \code{\link[preprocessCore]{normalize.quantiles}}.}
}
\value{
If augment = TRUE, a tibble with the same number of rows and columns as
tof_tibble, with the columns specified by `channel_cols` batch-corrected. If
augment = FALSE, a tibble containing only the batch-corrected `channel_cols`.
}
\description{
This function performs quantile normalization on high-dimensional cytometry
data in tidy format using either linear rescaling or quantile normalization.
Each channel specified by `channel_cols` is batch corrected, and `group_cols`
can be used to break cells
into groups for which the batch correction should be performed separately.
}
\examples{
NULL

}
