% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{tof_assess_channels}
\alias{tof_assess_channels}
\title{Detect low-expression (i.e. potentially failed) channels in high-dimensional cytometry data}
\usage{
tof_assess_channels(
  tof_tibble,
  channel_cols = where(tof_is_numeric),
  negative_threshold = asinh(10/5),
  negative_proportion_flag = 0.95
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or `tibble`.}

\item{channel_cols}{A vector of unquoted column names representing columns that contain
single-cell protein measurements. Supports tidyselect helpers.
If nothing is specified, the default is to analyze all numeric columns.}

\item{negative_threshold}{A scalar indicating the threshold below
which a measurement should be considered negative. Defaults to the hyperbolic
arcsine transformation of 10 counts.}

\item{negative_proportion_flag}{A scalar between 0 and 1 indicating the proportion of
cells in tof_tibble that need to be below `negative_threshold` for a given marker
in order for that marker to be flagged. Defaults to 0.95.}
}
\value{
A tibble 3 columns and a number of rows equal to the number of
columns in `tof_tibble` chosen by `channel_cols`. The three columns are "channel",
a character vector of channel names, "negative_proportion", a numeric vector with values
between 0 and 1 indicating how many cells in `tof_tibble` below `negative_threshold` for
each channel, and `flagged_channel`, a boolean vector indicating whether or not a channel
has been flagged as potentially failed (TRUE means that the channel had a large number of
cells below `negative_threshold`).
}
\description{
Detect low-expression (i.e. potentially failed) channels in high-dimensional cytometry data
}
\examples{
# simulate some data
sim_data <-
    data.frame(
        cd4 = rnorm(n = 100, mean = 5, sd = 0.5),
        cd8 = rnorm(n = 100, mean = 0, sd = 0.1),
        cd33 = rnorm(n = 100, mean = 10, sd = 0.1)
    )

tof_assess_channels(tof_tibble = sim_data)

tof_assess_channels(tof_tibble = sim_data, channel_cols = c(cd4, cd8))

tof_assess_channels(tof_tibble = sim_data, negative_threshold = 2)

}
