% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/developmental_classifier_helpers.R
\name{tof_apply_classifier}
\alias{tof_apply_classifier}
\title{Perform developmental clustering on CyTOF data using a pre-fit classifier}
\usage{
tof_apply_classifier(
  cancer_tibble = NULL,
  classifier_fit = NULL,
  distance_function = c("mahalanobis", "cosine", "pearson"),
  num_cores = 1,
  parallel_vars
)
}
\arguments{
\item{cancer_tibble}{A `tibble` or `tof_tibble` containing cells to be classified
into their nearest healthy subpopulation (generally cancer cells).}

\item{classifier_fit}{A nested `tibble` produced by `tof_build_classifier` in which
each row represents a healthy cell subpopulation into which the cells in `cancer_tibble`
should be classified using minimum distance.}

\item{distance_function}{A string indicating which distance function should
be used to perform the classification. Options are "mahalanobis" (the default),
"cosine", and "pearson".}

\item{num_cores}{An integer indicating the number of CPU cores used to parallelize
the classification. Defaults to 1 (a single core).}

\item{parallel_vars}{Unquoted column names indicating which columns in `cancer_tibble` to
use for breaking up the data in order to parallelize the classification.
Defaults to NULL. Supports tidyselect helpers.}
}
\value{
A tibble with `nrow(cancer_tibble)` rows and `nrow(classifier_fit) + 1`
columns. Each row represents a cell from `cancer_tibble`, and `nrow(classifier_fit)`
of the columns represent the distance between the cell and each of the healthy
subpopulations' cluster centroids. The final column represents the cluster id of
the healthy subpopulation with the minimum distance to the cell represented
by that row.
}
\description{
Perform developmental clustering on CyTOF data using a pre-fit classifier
}
\examples{
NULL

}
