% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tof_annotate_clusters}
\alias{tof_annotate_clusters}
\title{Manually annotate tidytof-computed clusters using user-specified labels}
\usage{
tof_annotate_clusters(tof_tibble, cluster_col, annotations)
}
\arguments{
\item{tof_tibble}{`tof_tbl` or `tibble`.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
contains the ids of the unsupervised cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{annotations}{A data structure indicating how to annotate each cluster id
in `cluster_col`. `annotations` can be provided as a data.frame with two columns
(the first should have the same name as `cluster_col` and contain each unique
cluster id; the second can have any name and should contain a character vector
indicating which manual annotation should be matched with each cluster
id in the first column). `annotations` can also be provided as a named character vector;
in this case, each entry in `annotations` should be a unique cluster id, and the
names for each entry should be the corresponding manual cluster annotation. See
below for examples.}
}
\value{
A `tof_tbl` with the same number of rows as `tof_tibble` and one
additional column containing the manual cluster annotations for each cell
(as a character vector). If `annotations` was provided as a data.frame, the
new column will have the same name as the column containing the cluster annotations
in `annotations`. If `annotations` was provided as a named character vector,
the new column will be named `\{cluster_col\}_annotation`.
}
\description{
This function adds an additional column to a `tibble` or `tof_tbl` to allow
users to incorporate manual cell type labels for clusters identified using
unsupervised algorithms.
}
\examples{

sim_data <-
    dplyr::tibble(
        cd45 = rnorm(n = 1000),
        cd38 = c(rnorm(n = 500), rnorm(n = 500, mean = 2)),
        cd34 = c(rnorm(n = 500), rnorm(n = 500, mean = 4)),
        cd19 = rnorm(n = 1000),
        cluster_id = c(rep("a", 500), rep("b", 500))
    )

# using named character vector
sim_data |>
    tof_annotate_clusters(
        cluster_col = cluster_id,
        annotations = c("macrophage" = "a", "dendritic cell" = "b")
    )

# using two-column data.frame
annotation_data_frame <-
    data.frame(
        cluster_id = c("a", "b"),
        cluster_annotation = c("macrophage", "dendritic cell")
    )

sim_data |>
    tof_annotate_clusters(
        cluster_col = cluster_id,
        annotations = annotation_data_frame
    )

}
