% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_discovery.R
\name{tof_analyze_expression_diffcyt}
\alias{tof_analyze_expression_diffcyt}
\title{Differential Expression Analysis (DEA) with diffcyt}
\usage{
tof_analyze_expression_diffcyt(
  tof_tibble,
  sample_col,
  cluster_col,
  marker_cols = where(tof_is_numeric),
  fixed_effect_cols,
  random_effect_cols,
  diffcyt_method = c("lmm", "limma"),
  include_observation_level_random_effects = FALSE,
  min_cells = 3,
  min_samples = 5,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{sample_col}{An unquoted column name indicating which column in `tof_tibble`
represents the id of the sample from which each cell was collected. `sample_col`
should serve as a unique identifier for each sample collected during data acquisition -
all cells with the same value for `sample_col` will be treated as a part of the same
observational unit.}

\item{cluster_col}{An unquoted column name indicating which column in `tof_tibble`
stores the cluster ids of the cluster to which each cell belongs.
Cluster labels can be produced via any method the user chooses - including manual gating,
any of the functions in the `tof_cluster_*` function family, or any other method.}

\item{marker_cols}{Unquoted column names representing which columns in `tof_tibble`
(i.e. which high-dimensional cytometry protein measurements) should be tested for differential expression between
levels of the `fixed_effect_cols`. Defaults to all numeric (integer or double) columns.
Supports tidyselect helpers.}

\item{fixed_effect_cols}{Unquoted column names representing which columns in
`tof_tibble` should be used to model fixed effects during the differential
expression analysis. Generally speaking, fixed effects represent the
comparisons of biological interest (often the the variables manipulated during
experiments), such as treated vs. non-treated, before-treatment vs. after-treatment,
or healthy vs. non-healthy.}

\item{random_effect_cols}{Unquoted column names representing which columns in
`tof_tibble` should be used to model random effects during the differential
expression analysis. Generally speaking, random effects represent variables
that a researcher wants to control/account for, but that are not necessarily
of biological interest. Example random effect variables might include batch id,
patient id (in a paired design), or patient age.

Note that without many samples at each level of each of the
random effect variables, it can be easy to overfit mixed models. For most high-dimensional cytometry
experiments, 2 or fewer (and often 0) random effect variables are appropriate.}

\item{diffcyt_method}{A string indicating which diffcyt method should be used for the
differential expression analysis. Valid methods include "lmm" (the default)
and "limma".}

\item{include_observation_level_random_effects}{A boolean value indicating
if "observation-level random effects" (OLREs) should be included as random effect
terms in a "lmm" differential expression model. For details about what OLREs are, see
\href{https://www.nature.com/articles/s42003-019-0415-5}{the diffcyt paper}.
Defaults to FALSE.}

\item{min_cells}{An integer value used to filter clusters out of the differential
expression analysis. Clusters are not included in the differential expression testing
if they do not have at least `min_cells` in at least `min_samples` samples.
Defaults to 3.}

\item{min_samples}{An integer value used to filter clusters out of the differential
expression analysis. Clusters are not included in the differential expression testing
if they do not have at least `min_cells` in at least `min_samples` samples.
Defaults to 5.}

\item{alpha}{A numeric value between 0 and 1 indicating which significance
level should be applied to multiple-comparison adjusted p-values during the
differential abundance analysis. Defaults to 0.05.}

\item{...}{Optional additional arguments to pass to the under-the-hood diffcyt
function being used to perform the differential expression analysis. See
\code{\link[diffcyt]{testDS_LMM}} and \code{\link[diffcyt]{testDS_limma}}
for details.}
}
\value{
A nested tibble with two columns: `tested_effect` and `dea_results`.

The first column, `tested_effect`
is a character vector indicating which term in the differential expression model
was used for significance testing. The values in this row are obtained
by pasting together the column names for each fixed effect variable and each
of its values. For example, a fixed effect column named fixed_effect with
levels "a", "b", and "c" have two terms in `tested_effect`: "fixed_effectb" and
"fixed_effectc" (note that level "a" of fixed_effect is set as the reference
level during dummy coding). These values correspond to the terms in the
differential expression model that represent the difference in cluster median
expression values of each marker between samples with fixed_effect = "b" and
fixed_effect = "a" and between samples with fixed_effect = "c" and
fixed_effect = "a", respectively. In addition,
note that the first row in `tested_effect` will always represent the "omnibus"
test, or the test that there are significant differences between \emph{any} levels of
\emph{any} fixed effect variable in the model.

The second column, `dea_results` is a list of tibbles in which each entry gives
the differential expression results for each tested_effect. Within each entry
of `dea_results`, you will find `p_val`, the p-value associated with each
tested effect in each input cluster/marker pair; `p_adj`, the multiple-comparison
adjusted p-value (using the \code{\link[stats]{p.adjust}} function), and
other values associated with the underlying method used to perform the
differential expression analysis (such as the log-fold change of clusters' median
marker expression values between the conditions being compared). Each tibble in `dea_results`
will also have two columns representing the cluster and marker corresponding to the
p-value in each row.
}
\description{
This function performs differential expression analysis on the cell clusters
contained within a `tof_tbl` using one of two
methods implemented in the \href{https://www.bioconductor.org/packages/release/bioc/html/diffcyt.html}{diffcyt}
package for differential discovery analysis in high-dimensional cytometry
data.
}
\details{
The two methods are based on linear mixed models ("lmm") and
\href{https://academic.oup.com/nar/article/43/7/e47/2414268}{limma} ("limma").
Both the "lmm" and "limma" methods can model both fixed effects and random
effects.
}
\examples{
# For differential discovery examples, please see the package vignettes
NULL

}
\seealso{
Other differential expression analysis functions: 
\code{\link{tof_analyze_expression}()},
\code{\link{tof_analyze_expression_lmm}()},
\code{\link{tof_analyze_expression_ttest}()}
}
\concept{differential expression analysis functions}
