% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_discovery.R
\name{tof_analyze_expression}
\alias{tof_analyze_expression}
\title{Perform Differential Expression Analysis (DEA) on high-dimensional cytometry data}
\usage{
tof_analyze_expression(tof_tibble, method = c("diffcyt", "glmm", "ttest"), ...)
}
\arguments{
\item{tof_tibble}{A `tof_tbl` or a `tibble`.}

\item{method}{A string indicating which statistical method should be used. Valid
values include "diffcyt", "lmm", and "ttest".}

\item{...}{Additional arguments to pass onto the `tof_analyze_expression_*`
function family member corresponding to the chosen method.}
}
\value{
A tibble or nested tibble containing the differential abundance results
from the chosen method. See \code{\link{tof_analyze_expression_diffcyt}},
\code{\link{tof_analyze_expression_lmm}}, and \code{\link{tof_analyze_expression_ttest}} for details.
}
\description{
This function performs differential expression analysis on the cell clusters
contained within a `tof_tbl` using one of three methods
("diffcyt", "glmm", and "ttest"). It wraps the members of the `tof_analyze_expression_*`
function family: \code{\link{tof_analyze_expression_diffcyt}},
\code{\link{tof_analyze_expression_lmm}}, and \code{\link{tof_analyze_expression_ttest}}.
}
\examples{
# For differential discovery examples, please see the package vignettes
NULL

}
\seealso{
Other differential expression analysis functions: 
\code{\link{tof_analyze_expression_diffcyt}()},
\code{\link{tof_analyze_expression_lmm}()},
\code{\link{tof_analyze_expression_ttest}()}
}
\concept{differential expression analysis functions}
