% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rev_asinh}
\alias{rev_asinh}
\title{Reverses arcsinh transformation with cofactor `scale_factor` and a
shift of `shift_factor`.}
\usage{
rev_asinh(x, shift_factor, scale_factor)
}
\arguments{
\item{x}{A numeric vector.}

\item{shift_factor}{The scalar value `a` in the following equation used to
transform high-dimensional cytometry raw data ion counts using the hyperbolic arcsinh function:
   `new_x <- asinh(a + b * x)`.}

\item{scale_factor}{The scalar value `b` in the following equation used to
transform high-dimensional cytometry raw data ion counts using the hyperbolic arcsinh function:
   `new_x <- asinh(a + b * x)`.}
}
\value{
A numeric vector after undergoing reverse
arcsinh transformation
}
\description{
Reverses arcsinh transformation with cofactor `scale_factor` and a
shift of `shift_factor`.
}
\examples{
shift_factor <- 0
scale_factor <- 1 / 5

input_value <- 20
asinh_value <- asinh(shift_factor + input_value * scale_factor)

restored_value <- rev_asinh(asinh_value, shift_factor, scale_factor)

}
