% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ddpr_metadata}
\alias{ddpr_metadata}
\title{Clinical metadata for each patient sample in Good & Sarno et al. (2018).}
\format{
A data frame with 10000 rows and 12 variables:
\describe{
  \item{patient_id}{Name of the sample from which the data was read}
  \item{gender}{Gender of the patient from which each sample was collected}
  \item{age_at_diagnosis}{Age (in years) of the patient from which each sample was collected}
  \item{wbc_count}{The diagnostic White Blood Cell (WBC) count of the patient from which each sample was collected}
  \item{mrd_risk}{Risk stratification category for each patient using minimal residual disease (MRD) criteria}
  \item{nci_rome_risk}{Risk stratification category for each patient using National Cancer Institute (NCI) criteria}
  \item{relapse_status}{A string representing whether or not a patient relapsed}
  \item{time_to_relapse}{The time (in days) it took each patient to relapse. Patients who did not relapse will have the value of NA}
  \item{type_of_relapse}{
  A string representing the timing of relapse for each patient.
  "Very early" relapses occurred less than 18 months after diagnosis;
  "Early" relapses occurred between 18 months and 32 months after diagnosis;
  "Late" relapses occurred later than 32 months after diagnosis.
  }
  \item{ccr}{The number of documented days of continuous complete remission (CCR) for patients who did not relapse. All patients who relapsed will have a value of NA.}
  \item{cohort}{A string representing if each sample was used in the "Training" or "Validation" cohort in the original study}
  \item{ddpr_risk}{The risk category ("Low" or "High") assigned to each sample using the original paper's risk-stratification algorithm}
}
}
\source{
Good Z, Sarno J, et al.
Single-cell developmental classification of B cell precursor acute
lymphoblastic leukemia at diagnosis reveals predictors of relapse.
Nat Med. 2018 May;24(4):474-483. doi: 10.1038/nm.4505. Epub 2018 Mar 5.
PMID: 29505032; PMCID: PMC5953207. Supplementary Table 1.
}
\usage{
data(ddpr_metadata)
}
\value{
A data.frame
}
\description{
A dataset containing patient-level clinical metadata for samples originally studied
in the following paper: \cr \cr
Good Z, Sarno J, et al.
Single-cell developmental classification of B cell precursor acute
lymphoblastic leukemia at diagnosis reveals predictors of relapse.
Nat Med. 2018 May;24(4):474-483. doi: 10.1038/nm.4505. Epub 2018 Mar 5.
PMID: 29505032; PMCID: PMC5953207.
}
\keyword{datasets}
