% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ddpr_data}
\alias{ddpr_data}
\title{CyTOF data from two samples: 5,000 B-cell lineage cells from a healthy
patient and 5,000 B-cell lineage cells from a B-cell precursor Acute
Lymphoblastic Leukemia (BCP-ALL) patient.}
\format{
A data frame with 10000 rows and 24 variables:
\describe{
  \item{sample_name}{name of the sample from which the data was read}
  \item{cd45}{A CyTOF measurement in raw ion counts}
  \item{cd19}{A CyTOF measurement in raw ion counts}
  \item{cd22}{A CyTOF measurement in raw ion counts}
  \item{cd79b}{A CyTOF measurement in raw ion counts}
  \item{cd20}{A CyTOF measurement in raw ion counts}
  \item{cd34}{A CyTOF measurement in raw ion counts}
  \item{cd123}{A CyTOF measurement in raw ion counts}
  \item{cd10}{A CyTOF measurement in raw ion counts}
  \item{cd24}{A CyTOF measurement in raw ion counts}
  \item{cd127}{A CyTOF measurement in raw ion counts}
  \item{cd43}{A CyTOF measurement in raw ion counts}
  \item{cd38}{A CyTOF measurement in raw ion counts}
  \item{cd58}{A CyTOF measurement in raw ion counts}
  \item{psyk}{A CyTOF measurement in raw ion counts}
  \item{p4ebp1}{A CyTOF measurement in raw ion counts}
  \item{pstat5}{A CyTOF measurement in raw ion counts}
  \item{pakt}{A CyTOF measurement in raw ion counts}
  \item{ps6}{A CyTOF measurement in raw ion counts}
  \item{perk}{A CyTOF measurement in raw ion counts}
  \item{pcreb}{A CyTOF measurement in raw ion counts}
}
}
\source{
\url{https://github.com/kara-davis-lab/DDPR}
}
\usage{
data(ddpr_data)
}
\value{
A data.frame
}
\description{
A dataset containing CyTOF measurements from immune cells originally studied
in the following paper:  \cr \cr
Good Z, Sarno J, et al.
Single-cell developmental classification of B cell precursor acute
lymphoblastic leukemia at diagnosis reveals predictors of relapse.
Nat Med. 2018 May;24(4):474-483. doi: 10.1038/nm.4505. Epub 2018 Mar 5.
PMID: 29505032; PMCID: PMC5953207.
}
\keyword{datasets}
