% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{as_seurat}
\alias{as_seurat}
\alias{as_seurat.tof_tbl}
\title{Coerce an object into a \code{\link[SeuratObject]{SeuratObject}}}
\usage{
as_seurat(x, ...)

\method{as_seurat}{tof_tbl}(
  x,
  channel_cols = where(tof_is_numeric),
  reduced_dimensions_cols,
  metadata_cols = where(function(.x) !tof_is_numeric(.x)),
  split_reduced_dimensions = FALSE,
  ...
)
}
\arguments{
\item{x}{A tof_tbl}

\item{...}{Unused.}

\item{channel_cols}{Unquoted column names representing columns that contain
single-cell protein measurements. Supports tidyselect helpers.
If nothing is specified, the default is all numeric columns.}

\item{reduced_dimensions_cols}{Unquoted column names representing columns that contain
dimensionality reduction embeddings, such as tSNE or UMAP embeddings.
Supports tidyselect helpers.}

\item{metadata_cols}{Unquoted column names representing columns that contain
metadata about the samples from which each cell was collected. If nothing
is specified, the default is all non-numeric columns.}

\item{split_reduced_dimensions}{A boolean value indicating whether the
dimensionality results in x should be split into separate slots in the resulting
\code{\link[SingleCellExperiment]{SingleCellExperiment}}. If FALSE (the default),
the split will not be performed and the
\code{\link[SingleCellExperiment]{reducedDims}} slot in the result will have
a single entry ("tidytof_reduced_dimensions"). If TRUE, the split will be
performed and the \code{\link[SingleCellExperiment]{reducedDims}} slot in
the result will have 1-4 entries depending on which dimensionality reduction
results are present in x ("tidytof_pca", "tidytof_tsne", "tidytof_umap",
and "tidytof_reduced_dimensions"). Note that "tidytof_reduced_dimensions" will
include all dimensionality reduction results that are not named according to
tidytof's pca, umap, and tsne conventions.}
}
\value{
A \code{\link[SeuratObject]{SeuratObject}}

A \code{\link[SeuratObject]{SeuratObject}}.
}
\description{
Coerce an object into a \code{\link[SeuratObject]{SeuratObject}}

Coerce a tof_tbl into a \code{\link[SeuratObject]{SeuratObject}}
}
\examples{
NULL

NULL

}
