% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_SummarizedExperiment.R
\docType{methods}
\name{as_SummarizedExperiment}
\alias{as_SummarizedExperiment}
\alias{as_SummarizedExperiment,tbl_df-method}
\title{as_SummarizedExperiment}
\usage{
as_SummarizedExperiment(
  .data,
  .sample = NULL,
  .transcript = NULL,
  .abundance = NULL
)

\S4method{as_SummarizedExperiment}{tbl_df}(
  .data,
  .sample = NULL,
  .transcript = NULL,
  .abundance = NULL
)
}
\arguments{
\item{.data}{A tibble}

\item{.sample}{The name of the sample column}

\item{.transcript}{The name of the transcript/gene column}

\item{.abundance}{The name of the transcript/gene abundance column}
}
\value{
A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
as_SummarizedExperiment() creates a `SummarizedExperiment` object from a `tbl` or `tidybulk` tbl formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> |
}
\examples{

# Convert tibble to SummarizedExperiment
library(tibble)
tibble(.sample = "A", .transcript = "CD3G", count = 1) |>
  as_SummarizedExperiment(.sample = .sample, .transcript = .transcript, .abundance = count)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7

Lawrence, M., Huber, W., Pagès, H., Aboyoun, P., Carlson, M., Gentleman, R., Morgan, M. T., & Carey, V. J. (2013). Software for computing and annotating genomic ranges. PLoS Computational Biology, 9(8), e1003118. doi:10.1371/journal.pcbi.1003118

Wickham, H., François, R., Henry, L., Müller, K., & Vaughan, D. (2023). dplyr: A Grammar of Data Manipulation. R package version 1.1.0. https://CRAN.R-project.org/package=dplyr
}
