% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{bind_rows}
\alias{bind_rows}
\alias{bind_rows.SummarizedExperiment}
\alias{bind_cols.SummarizedExperiment}
\alias{bind_cols}
\alias{bind_cols.RangedSummarizedExperiment}
\title{Efficiently bind multiple data frames by row and column}
\usage{
\method{bind_rows}{SummarizedExperiment}(..., .id = NULL, add.cell.ids = NULL)

\method{bind_cols}{SummarizedExperiment}(..., .id = NULL)

\method{bind_cols}{RangedSummarizedExperiment}(..., .id = NULL)
}
\arguments{
\item{...}{Data frames to combine.

  Each argument can either be a data frame, a list that could be a data
  frame, or a list of data frames.

  When row-binding, columns are matched by name, and any missing
  columns will be filled with NA.

  When column-binding, rows are matched by position, so all data
  frames must have the same number of rows. To match by value, not
  position, see mutate-joins.}

\item{.id}{Data frame identifier.

  When `.id` is supplied, a new column of identifiers is
  created to link each row to its original data frame. The labels
  are taken from the named arguments to `bind_rows()`. When a
  list of data frames is supplied, the labels are taken from the
  names of the list. If no names are found a numeric sequence is
  used instead.}

\item{add.cell.ids}{Appends the corresponding values to}
}
\value{
`bind_rows()` and `bind_cols()` return the same type as
  the first input, either a data frame, `tbl_df`, or `grouped_df`.

`bind_rows()` and `bind_cols()` return the same type as
  the first input, either a data frame, `tbl_df`, or `grouped_df`.
}
\description{
This is an efficient implementation of the common pattern of
`do.call(rbind, dfs)` or `do.call(cbind, dfs)` for binding many
data frames into one.

This is an efficient implementation of the common pattern of
`do.call(rbind, dfs)` or `do.call(cbind, dfs)` for binding many
data frames into one.
}
\details{
The output of `bind_rows()` will contain a column if that column
appears in any of the inputs.

The output of `bind_rows()` will contain a column if that column
appears in any of the inputs.
}
\examples{
print("small_pbmc |> bind_rows(small_pbmc)")



print("small_pbmc |> bind_cols(annotation_column)")
}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2
}
