% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble_methods.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.SummarizedExperiment}
\title{Coerce lists, matrices, and more to data frames}
\usage{
\method{as_tibble}{SummarizedExperiment}(
  x,
  ...,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  rownames = pkgconfig::get_config("tibble::rownames", NULL)
)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that could reasonably be
coerced to a tibble.}

\item{...}{Unused, for extensibility.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item \code{"unique_quiet"}: Same as \code{"unique"}, but "quiet"
\item \code{"universal_quiet"}: Same as \code{"universal"}, but "quiet"
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{rownames}{How to treat existing row names of a data frame or matrix:
\itemize{
\item \code{NULL}: remove row names. This is the default.
\item \code{NA}: keep row names.
\item A string: the name of a new column. Existing rownames are transferred
into this column and the \code{row.names} attribute is deleted.
No name repair is applied to the new column name, even if \code{x} already contains
a column of that name.
Use \code{as_tibble(rownames_to_column(...))} to safeguard against this case.
}

Read more in \link[tibble]{rownames}.}
}
\value{
\code{tibble}
}
\description{
\code{as_tibble()} turns an existing object, such as a data frame or
matrix, into a so-called tibble, a data frame with class \code{\link[tibble]{tbl_df}}. This is
in contrast with \code{\link[tibble:tibble]{tibble()}}, which builds a tibble from individual columns.
\code{as_tibble()} is to \code{\link[tibble:tibble]{tibble()}} as \code{\link[base:as.data.frame]{base::as.data.frame()}} is to
\code{\link[base:data.frame]{base::data.frame()}}.

\code{as_tibble()} is an S3 generic, with methods for:
\itemize{
\item \code{\link[base:data.frame]{data.frame}}: Thin wrapper around the \code{list} method
that implements tibble's treatment of \link[tibble]{rownames}.
\item \code{\link[base:matrix]{matrix}}, \code{\link[stats:poly]{poly}},
\code{\link[stats:ts]{ts}}, \code{\link[base:table]{table}}
\item Default: Other inputs are first coerced with \code{\link[base:as.data.frame]{base::as.data.frame()}}.
}

\code{as_tibble_row()} converts a vector to a tibble with one row.
If the input is a list, all elements must have size one.

\code{as_tibble_col()} converts a vector to a tibble with one column.
}
\section{Row names}{


The default behavior is to silently remove row names.

New code should explicitly convert row names to a new column using the
\code{rownames} argument.

For existing code that relies on the retention of row names, call
\code{pkgconfig::set_config("tibble::rownames" = NA)} in your script or in your
package's \code{\link[=.onLoad]{.onLoad()}}  function.

}

\section{Life cycle}{


Using \code{as_tibble()} for vectors is superseded as of version 3.0.0,
prefer the more expressive \code{as_tibble_row()} and
\code{as_tibble_col()} variants for new code.

}

\examples{
tidySummarizedExperiment::pasilla \%>\%
    as_tibble()
    
tidySummarizedExperiment::pasilla \%>\%
    as_tibble(.subset=-c(condition, type))

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Müller, K., Wickham, H. (2023). tibble: Simple Data Frames. R package version 3.2.1, https://CRAN.R-project.org/package=tibble
}
\seealso{
\code{\link[tibble:tibble]{tibble()}} constructs a tibble from individual columns. \code{\link[tibble:enframe]{enframe()}}
converts a named vector to a tibble with a column of names and column of
values. Name repair is implemented using \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
}
