% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{gate_interactive}
\alias{gate_interactive}
\title{Gate interactive}
\usage{
gate_interactive(spe, image_index, colour, shape, alpha, size, hide_points)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{image_index}{The image to display if multiple are stored within the provided
SpatialExperiment object.}

\item{colour}{A single colour string compatible with ggplot2. Or, a vector representing the
point colour.}

\item{shape}{A single ggplot2 shape numeric ranging from 0 to 127. Or, a vector representing the
point shape, coercible to a factor of 6 or less levels.}

\item{alpha}{A single ggplot2 alpha numeric ranging from 0 to 1.}

\item{size}{A single ggplot2 size numeric ranging from 0 to 20.}

\item{hide_points}{A logical. If TRUE, points are hidden during interactive gating. This can
greatly improve performance with large SpatialExperiment objects.}
}
\value{
The input SpatialExperiment object with a new column \code{.gated}, recording the
gates each X and Y coordinate pair is within. If gates are drawn interactively, they are
temporarily saved to \code{tidygate_env$gates}
}
\description{
Interactively gate points by their location in space, with image data overlaid.
}
\examples{
example(read10xVisium)
data(demo_brush_data, package = "tidySpatialExperiment")

if(interactive()) {
    spe |>
        gate(colour = "blue", shape = "in_tissue")
}
}
