% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{slice.flowFrame}
\alias{slice.flowFrame}
\title{Subset rows using their positions}
\usage{
\method{slice}{flowFrame}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Integer row values (to keep).}

\item{.by}{Optionally, an unquoted selection of columns to group by for just this operation.
An alternative to group_by.}

\item{.preserve}{Currently unused.}
}
\value{
An object of the same type as .data. The output has the following properties:
* Each row may appear 0, 1, or many times in the output.
* Columns are not modified.
* Groups are not modified.
* A \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} is preserved.
}
\description{
Subset rows using their positions
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::slice(1)

}
