% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{select.flowSet}
\alias{select.flowSet}
\title{Keep or drop columns using their names and types.}
\usage{
\method{select}{flowSet}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowSet}}}

\item{...}{One or more unquoted expressions separated by commas. Variables names
(as specified by the \code{\link[flowCore]{featureNames}} of the component flowFrames
that make up the flowSet) can be used as if they
were positions in the \code{\link[flowCore]{flowSet}}). Supports tidyselection.}
}
\value{
A \code{\link[flowCore]{flowSet}}. The output has the following properties:
* Rows are not affected.
* Output columns are a subset of input columns, potentially with a different order. Columns will be renamed if new_name = old_name form is used.
* The \code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}} will be preserved.
}
\description{
Keep or drop columns using their names and types.
}
\examples{
my_flowset <-
  simulate_cytometry_data()$flowset

my_flowset |>
  dplyr::select(feature_1)

}
