% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{rename.flowFrame}
\alias{rename.flowFrame}
\title{Rename columns in a \code{\link[flowCore]{flowFrame}}}
\usage{
\method{rename}{flowFrame}(.data, ...)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Unquoted name-value pairs (as specified by \code{\link[flowCore]{featureNames}}).
Use new_name = old_name to rename selected columns}
}
\value{
An object of the same type as .data. The output has the following properties:
* Rows are not affected.
* Column names are changed; column order is preserved.
* The \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} will be preserved.
}
\description{
Rename columns in a \code{\link[flowCore]{flowFrame}}
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::rename(new_feature = feature_1)

}
