% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_verbs.R
\name{ggplot.flowSet}
\alias{ggplot.flowSet}
\title{Create a new ggplot.}
\usage{
\method{ggplot}{flowSet}(
  data = NULL,
  mapping = ggplot2::aes(),
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{Default dataset to use for plot in the form of a
\code{\link[flowCore]{flowSet}}. If not specified, must be supplied in each
 layer added to the plot. Note that any metadata stored in
 \code{\link[Biobase]{pData}} will be merged into the underlying
 flowCore-tibble abstraction and will thus be available for plotting.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot. Note that
variable names used for aesthetic mappings come from the
\code{\link[flowCore]{featureNames}} of the input
\code{\link[flowCore]{flowSet}}'s constituent
\code{\link[flowCore]{flowFrame}}s.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{Deprecated. Used prior to tidy evaluation.}
}
\value{
A \code{\link[ggplot2]{ggplot}}
}
\description{
Create a new ggplot.
}
\examples{
simulations <- simulate_cytometry_data()
test_flowset <- simulations$flowset

flowset_plot <-
  test_flowset |>
  ggplot2::ggplot(ggplot2::aes(x = feature_1, y = feature_2)) +
  ggplot2::geom_point()

flowset_plot_with_metadata <-
  test_flowset |>
  # note that `patient` below comes from the flowSet's metadata (pData)
  ggplot2::ggplot(ggplot2::aes(x = feature_1, y = feature_2, color = patient)) +
  ggplot2::geom_point()
}
