% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{filter.flowFrame}
\alias{filter.flowFrame}
\title{Keep rows that match a condition.}
\usage{
\method{filter}{flowFrame}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Expressions that return a logical value, and are defined in terms
of the variables in the \code{\link[flowCore]{featureNames}} of .data.
If multiple expressions are included, they are combined with the & operator.
Only rows for which all conditions evaluate to TRUE are kept.}

\item{.by}{Optionally, a selection of columns to group by for just this
operation, functioning as an alternative to group_by().}

\item{.preserve}{Unused.}
}
\value{
An object of the same type as .data. The output has the
following properties:
* Rows are a subset of the input, but appear in the same order.
* Columns are not modified.
* The \code{\link[flowCore]{flowFrame}}'s \code{\link[flowCore]{identifier}} will be preserved.
}
\description{
Keep rows that match a condition.
}
\examples{

my_flowframe <- simulate_cytometry_data()$flowframe

 my_flowframe |>
   dplyr::filter(feature_1 > 50)


}
