% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{count.flowFrame}
\alias{count.flowFrame}
\title{Count the observations in each group.}
\usage{
\method{count}{flowFrame}(x, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Variables to group by, named according to
\code{\link[flowCore]{featureNames}}}

\item{wt}{If NULL (the default), counts the number of rows in each group.
If a variable, computes sum(wt) for each group.}

\item{sort}{If TRUE, will show the largest groups at the top.}

\item{name}{If omitted, it will default to n. If there's already a column
called n, it will use nn. If there's a column called n and nn, it'll use nnn,
and so on, adding ns until it gets a new name.}
}
\value{
A data.frame containing the groupwise counts.
}
\description{
Count the observations in each group.
}
\examples{
my_flowframe <-
  simulate_cytometry_data()$flowframe |>
    dplyr::mutate(
      random_group =
        sample(
          c("a", "b"),
          size = nrow(simulate_cytometry_data()$flowframe),
          replace = TRUE
        )
    )

 my_flowframe |>
   dplyr::count(random_group)

}
