% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{as_tof_tbl}
\alias{as_tof_tbl}
\title{Coerce flowFrames or flowSets into tibbles.}
\usage{
as_tof_tbl(
  flow_data,
  .name_method = c("tidyFlowCore", "featureNames", "colnames"),
  sep = "|",
  ...
)
}
\arguments{
\item{flow_data}{A flowFrame or flowSet}

\item{.name_method}{A string indicating how tidyFlowCore should extract column
names from `flow_data`. Available options are "tidyFlowCore" (the default), which
uses tidyFlowCore's internal heuristic to name columns; "featureNames", which
uses \code{\link[flowCore]{featureNames}} to name the columns; and "colnames",
which uses \code{\link[base]{colnames}} to name the columns. Note that,
in most cases, "featureNames" and "colnames" will give identical results.}

\item{sep}{A string indicating which symbol should be used to separate
antigen names and channel names in the columns of the output tof_tbl
when .name_method = 'tidyFlowCore'.}

\item{...}{Optional method-specific arguments.}
}
\value{
A cytometry-specialized tibble called a `tof_tbl`.
}
\description{
Coerce flowFrames or flowSets into tibbles.
}
\examples{

input_file <- system.file("extdata", "0877408774.B08", package="flowCore")

input_flowframe <- flowCore::read.FCS(input_file)

tof_tibble <- as_tof_tbl(input_flowframe)

}
