% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical.R
\name{sampleTypesTable}
\alias{sampleTypesTable}
\title{Get an overview of the samples available in the workspace}
\usage{
sampleTypesTable(
  workspace = terraTCGAworkspace(),
  namespace = .DEFAULT_NAMESPACE,
  tablename = .DEFAULT_TABLENAME,
  verbose = TRUE
)
}
\arguments{
\item{workspace}{character(1) The Terra Data Resources workspace from which
to pull TCGA data (default: see \code{terraTCGAworkspace()}). This is set to a
package-wide option.}

\item{namespace}{character(1) The Terra Workspace Namespace that
defaults to "broad-firecloud-tcga" and rarely needs to be changed.}

\item{tablename}{The Terra data model table from which to extract the
clinical data (default: "sample")}

\item{verbose}{logical(1) Whether to output additional information regarding
the workspace and namespace (default: \code{TRUE}).}
}
\value{
A \code{tibble} of sample codes and frequency along with their
definition and short letter code
}
\description{
The function provides an overview of samples from the \code{avtables("sample")}
table for the current workspace. Along with the sample codes and frequencies,
the output provides a description for each code and the short letter codes.
}
\examples{
if (
    GCPtools::gcloud_exists() &&
    identical(AnVILBase::avplatform_namespace(), "AnVILGCP") &&
    nzchar(AnVILGCP::avworkspace_name())
)
  sampleTypesTable(workspace = "TCGA_COAD_OpenAccess_V1-0_DATA")

}
