% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_converter.R
\name{id_converter}
\alias{id_converter}
\title{Convert the human gene identifier (hgnc_symbol or ensembl_gene_id) to
entrezgene_id format for the analysis.}
\usage{
id_converter(esetm, id_type, save_report = FALSE, outdir = tempdir())
}
\arguments{
\item{esetm}{A matrix with the gene count values and whose rownames are the
gene Ids (gene symbol or ensembl gene ID).}

\item{id_type}{A string representing the type of ID given as input. Must be
either hgnc_symbol or ensembl_gene_id.}

\item{save_report}{A boolean. By default, the duplicates report is not saved locally.}

\item{outdir}{Path to a directory where to save the report. If none is given,
a temporary directory will be chosen. No report will be creatted if save_report is
set to FALSE.}
}
\value{
A matrix with gene IDs in the entrezgene_id format. Also provides a
report on the duplicated mappings (conversion_report.txt) in the working dir.
}
\description{
Convert the human gene identifier (hgnc_symbol or ensembl_gene_id) to
entrezgene_id format for the analysis.
}
\examples{
# To showcase thisl internal function, a small example is made.
gene_ids <- c('ENSG00000103197', 'ENSG00000008710', 'ENSG00000167964'
, 'ENSG00000167964')
esetm <- matrix(c(
2.5, 3.1, 5.2, 0.1,
4.1, 2.9, 6.3, 0.5,
1.5, 3.7, 4.8, 0.1), nrow = 4, byrow = FALSE)
rownames(esetm) <- gene_ids
colnames(esetm) <- c("Sample 1", "Sample 2", "Sample 3")
# Call the function
esetm <- id_converter(esetm, "ensembl_gene_id")
print(head(esetm))
}
