% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terapadogBricks.R
\name{generate_permutation_matrix}
\alias{generate_permutation_matrix}
\title{Generate a Permutation Matrix for Group Assignments}
\usage{
generate_permutation_matrix(G, NI, paired, block, verbose)
}
\arguments{
\item{G}{A factor vector indicating the group assignment for each sample.}

\item{NI}{Integer. The maximum number of permutations allowed.}

\item{paired}{Logical. If TRUE, the function accounts for paired samples.}

\item{block}{A factor vector specifying the blocking variable for paired samples.}

\item{verbose}{Logical. If TRUE, the function prints the number of permutations used.}
}
\value{
A list containing:
  \item{combidx}{A matrix where each column is a permutation of sample indices.}
  \item{NI}{The number of permutations used.}
  \item{bigG}{A vector of group labels excluding the smallest group.}
  \item{minG}{The group label with the smallest number of samples.}
}
\description{
This function generates a permutation matrix based on given sample groups,
handling paired and unpaired designs. It also returns the group in the experiment
with the least and most samples. Finally, it recomputes the necessary iterations,
based on the permutations done.
}
\examples{
G <- factor(rep(c("Wt", "Mut"), each = 3))
block <- factor(rep(c("Pat1", "Pat2", "Pat3", "Pat1", "Pat2", "Pat3")))
result <- terapadog:::generate_permutation_matrix(G, NI = 1000, paired = TRUE, block = block, verbose = FALSE)

}
\keyword{internal}
