% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rank_product}
\alias{rank_product}
\title{Calculate the regions rank products}
\usage{
rank_product(region_score, region_stat, region_id)
}
\arguments{
\item{region_score}{A vector of numerics}

\item{region_stat}{A vector of numerics}

\item{region_id}{A vector of characters}
}
\value{
A vector of numerics
}
\description{
Calculate the rank products of the rank of the distances and the statistics.
}
\examples{
library(IRanges)

query <- IRanges(c(1, 4, 9), c(5, 7, 10))
subject <- IRanges(c(2, 2, 10), c(2, 3, 12))
distance <- find_distance(query, subject)
peak_score <- score_peaks(distance, 100000)
region_id <- c('region1', 'region1', 'region2')
region_score <- score_regions(peak_score, region_id)
region_stat <- c(30, 30, -40)
rank_product(region_score, region_stat, region_id)

}
