% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{find_distance}
\alias{find_distance}
\title{Find the distance between peaks and regions}
\usage{
find_distance(peaks, regions, how = "center")
}
\arguments{
\item{peaks}{A GRanges object}

\item{regions}{A GRanges object}

\item{how}{A character string, default 'center'}
}
\value{
A vector of integers
}
\description{
Calculate the distance between the elements of two GRanges objects.
}
\examples{
library(IRanges)

query <- IRanges(c(1, 4, 9), c(5, 7, 10))
subject <- IRanges(c(2, 2, 10), c(2, 3, 12))
find_distance(query, subject)

}
