% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggevonet.R
\name{ggevonet}
\alias{ggevonet}
\title{ggevonet}
\usage{
ggevonet(tr, mapping = NULL, layout = "slanted", mrsd = NULL,
  as.Date = FALSE, yscale = "none", yscale_mapping = NULL,
  ladderize = FALSE, right = FALSE, branch.length = "branch.length",
  ndigits = NULL, min_crossing = TRUE, ...)
}
\arguments{
\item{tr}{a evonet object}

\item{mapping}{aes mapping}

\item{layout}{one of 'rectangular', 'slanted'}

\item{mrsd}{most recent sampling date}

\item{as.Date}{logical whether using Date class in time tree}

\item{yscale}{y scale}

\item{yscale_mapping}{yscale mapping for category variable}

\item{ladderize}{logical}

\item{right}{logical}

\item{branch.length}{variable for scaling branch, if 'none' draw cladogram}

\item{ndigits}{number of digits to round numerical annotation variable}

\item{min_crossing}{logical, rotate clades to minimize crossings}

\item{...}{additional parameter}
}
\value{
tree
}
\description{
drawing phylogenetic tree from phylo object
}
\examples{
(enet <- ape::read.evonet(text='((a:2,(b:1)#H1:1):1,(#H1,c:1):2);'))
ggevonet(enet) + geom_tiplab()
ggevonet(enet, layout = "rectangular") + geom_tiplab()

}
\seealso{
\code{\link[ape]{evonet}}, \code{\link[ggtree]{ggtree}}
}
\author{
Klaus Schliep
}
