% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modP.R
\name{modP}
\alias{modP}
\alias{modP,numeric,numeric-method}
\title{DAR-moderated \emph{p}-values}
\usage{
modP(pvals, dar, slope = -1.8)

\S4method{modP}{numeric,numeric}(pvals, dar, slope = -1.8)
}
\arguments{
\item{pvals}{\code{numeric} of feature-level \emph{p}-values from differential
expression testing.}

\item{dar}{\code{numeric} of DAR values assigned to corresponding features
tested for differential expression.}

\item{slope}{\code{numeric(1)} specifying the slope of alpha fit.}
}
\value{
\code{numeric} of DAR-moderated \emph{p}-values of same length as
input \emph{p}-values.
}
\description{
Moderate \emph{p}-values from DE testing using assigned DAR values.
}
\examples{
data("chr1_genes")
data("chr1_tt")
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
props <- countsToProps(counts_filt)
contrasts <- matrix(
    data = c(1, -1),
    dimnames = list(
        Levels = c("group1", "group2"),
        Contrasts = c("group1v2")
    )
)
dar <- dar(props, contrasts, region_loci = 5)
dar_regions <- flipRanges(dar, extend_edges = TRUE)
gene_dar <- assignFeatureDar(dar_regions, chr1_genes, dar_val = "region")
chr1_tt <- merge(chr1_tt, mcols(gene_dar$group1v2), sort = FALSE)
chr1_tt$darP <- modP(chr1_tt$PValue, chr1_tt$dar)

}
