
context("tRNA summary")
test_that("tRNA summary:",{
  data("gr", package = "tRNA")
  tRNA <- gr
  tRNA <- tRNA[1:10]
  actual <- gettRNASummary(tRNA)
  expect_s4_class(actual,"DataFrame")
  expect_type(actual$gc,"double")
  expect_type(actual$width,"integer")
  expect_type(actual$length,"integer")
  expect_type(actual$cca,"logical")
  expect_type(actual$features_all_valid,"logical")
  expect_type(actual$features_Dstem_found,"logical")
  expect_type(actual$features_Tstem_found,"logical")
  expect_type(actual$acceptorStem_length,"integer")
  expect_type(actual$Dprime5_length,"integer")
  expect_type(actual$DStem_length,"integer")
  expect_type(actual$Dloop_length,"integer")
  expect_type(actual$Dprime3_length,"integer")
  expect_type(actual$anticodonStem_length,"integer")
  expect_type(actual$anticodonLoop_length,"integer")
  expect_type(actual$variableLoop_length,"integer")
  expect_type(actual$TStem_length,"integer")
  expect_type(actual$Tloop_length,"integer")
  expect_type(actual$discriminator_length,"integer")
  expect_type(actual$acceptorStem_unpaired,"logical")
  expect_type(actual$DStem_unpaired,"logical")
  expect_type(actual$anticodonStem_unpaired,"logical")
  expect_type(actual$variableLoop_unpaired,"logical")
  expect_type(actual$TStem_unpaired,"logical")
  expect_type(actual$acceptorStem_mismatches,"logical")
  expect_type(actual$DStem_mismatches,"logical")
  expect_type(actual$anticodonStem_mismatches,"logical")
  expect_type(actual$variableLoop_mismatches,"logical")
  expect_type(actual$TStem_mismatches,"logical")
  expect_type(actual$acceptorStem_bulges,"logical")
  expect_type(actual$DStem_bulges,"logical")
  expect_type(actual$anticodonStem_bulges,"logical")
  expect_type(actual$variableLoop_bulges,"logical")
  expect_type(actual$TStem_bulges,"logical")
  expect_type(actual$tRNAscan_score,"double")
  expect_type(actual$tRNAscan_potential.pseudogene,"logical")
  expect_type(actual$tRNAscan_intron,"logical")
  expect_type(actual$tRNAscan_hmm.score,"double")
  expect_type(actual$tRNAscan_sec.str.score,"double")
  expect_type(actual$tRNAscan_infernal,"double")
  #
  actual <- gettRNASummary(GRangesList(tRNA,tRNA))
  expect_type(actual,"list")
})
