% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/tRNA-sequences.R,
%   R/tRNA-structures.R
\name{gettRNAstructureGRanges}
\alias{gettRNAstructureGRanges}
\alias{gettRNAstructureSeqs}
\alias{gettRNAstructureSeqs,GRanges-method}
\alias{gettRNAstructureGRanges,GRanges-method}
\title{tRNA structures and sequences}
\usage{
gettRNAstructureGRanges(x, structure = "")

gettRNAstructureSeqs(
  x,
  structure = "",
  joinCompletely = FALSE,
  joinFeatures = FALSE,
  padSequences = TRUE
)

\S4method{gettRNAstructureSeqs}{GRanges}(
  x,
  structure = "",
  joinCompletely = FALSE,
  joinFeatures = FALSE,
  padSequences = TRUE
)

\S4method{gettRNAstructureGRanges}{GRanges}(x, structure = "")
}
\arguments{
\item{x}{a GRanges object with tRNA information. It has to pass the
\code{istRNAGRanges} function.}

\item{structure}{optional parameter for returning just partial sequences.
The following values are accepted:
\code{anticodonStem}, \code{Dprime5}, \code{DStem}, \code{Dloop},
\code{Dprime3}, \code{acceptorStem}, \code{anticodonloop},
\code{variableLoop}, \code{TStem}, \code{Tloop}, \code{discriminator}.
(default: \code{structure = ""})}

\item{joinCompletely}{Should the sequence parts, which are to be returned, be
joined into one sequence? (default: \code{joinCompletely = FALSE}))
Setting this to TRUE excludes \code{joinFeatures} be set to TRUE as well. In
addition, \code{joinCompletely = TRUE} uses automatically all sequence
structures.}

\item{joinFeatures}{Should the sequence parts, which are to be returned and
are from the same structure type, be joined into one sequence?
(default: \code{joinCompletely = FALSE})) Setting this to TRUE excludes
\code{joinCompletely} be set to TRUE as well. \code{joinCompletely} takes
precedence.}

\item{padSequences}{parameter whether sequences of the same type
should be returned with the same length. For stems missing positions will be
filled up in the middle, for loops at the ends.
(default: \code{padSequences = TRUE}). If \code{joinCompletely == TRUE} this
is set to TRUE automatically.}
}
\value{
a list of \code{GRanges} or \code{DNAStringSet} objects. In case
joinCompletly is set to TRUE a single \code{DNAStringSet} is returned.
}
\description{
\code{gettRNAstructureGRanges} returns a list of GRanges describing the
boundaries of tRNA structures as extracted from the dot bracket annotation.
The dot bracket annotation is parsed using \code{gettRNABasePairing}, which
internally uses \code{getBasePairing}.

\code{gettRNAstructureSeq} returns split or partial tRNA sequences based on
the structure information. Variations in the ength of structure features can
be padded to retrieve sequences of equal length. If sequences are joined by
setting \code{joinCompletely = FALSE}, the boundaries of the tRNA structure
are stored in the result as metadata. They can be accessesed as an IRanges
object by using \code{metadata(seq)[["tRNA_structures"]]}.
}
\examples{
data("gr", package = "tRNA")
gettRNAstructureGRanges(gr, structure = "anticodonLoop")
gettRNAstructureSeqs(gr, structure = "anticodonLoop")
gettRNABasePairing(gr[1:10])
}
