% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatMaplot.R
\name{heatMaplot}
\alias{heatMaplot}
\title{Hierarchical Clustering HeatMap (heatMaplot)}
\usage{
heatMaplot(
  exploredds,
  clust,
  DEGlist = NULL,
  plotly = FALSE,
  savePlot = FALSE,
  filePlot = NULL,
  ...
)
}
\arguments{
\item{exploredds}{object of class \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}}.}

\item{clust}{select the data to apply the distance matrix computation.
If \code{samples} selected, it will be applied the \code{\link[stats:dist]{stats::dist()}} function to the
transformed count matrix to get sample-to-sample distances. If \code{ind}, it is
necessary to provide the list of differentially expressed genes,
for the \code{exploredds} subset.}

\item{DEGlist}{List of up or down regulated gene/transcript identifiers
meeting the chosen filter settings for all comparisons defined in data
frames \code{pval} and \code{log2FC}.}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned. \code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}

\item{...}{additional parameters for the \code{\link[pheatmap:pheatmap]{pheatmap::pheatmap()}} function.}
}
\value{
returns an object of \code{pheatmap} or \code{plotly} class.
}
\description{
This function performs hierarchical clustering on the
transformed expression matrix generated with the DESeq2 package. It uses,
by default, a Pearson correlation-based distance measure and complete linkage
for cluster join.
}
\examples{
### Load data
targetspath <- system.file("extdata", "targets.txt", 
package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, 
format = "matrix", delim = "-")
countMatrixPath <- system.file("extdata", "countDFeByg.xls", 
package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Samples plot
exploredds <- exploreDDS(countMatrix, targets,
    cmp = cmp[[1]],
    preFilter = NULL, transformationMethod = "rlog"
)
heatMaplot(exploredds, clust = "samples", plotly = TRUE)
## Individuals genes identified in DEG analysis
### DEG analysis with `systemPipeR`
degseqDF <- systemPipeR::run_DESeq2(
    countDF = countMatrix,
    targets = targets, cmp = cmp[[1]], independent = FALSE
)
DEG_list <- systemPipeR::filterDEGs(
    degDF = degseqDF,
    filter = c(Fold = 2, FDR = 10)
)
### Plot
heatMaplot(exploredds,
    clust = "ind",
    DEGlist = unique(as.character(unlist(DEG_list[[1]])))
)
}
\references{
Raivo Kolde (2019). pheatmap: Pretty Heatmaps. R package version 1.0.12.
\url{https://CRAN.R-project.org/package=pheatmap}
}
\keyword{visualization}
