\name{olBarplot}
\alias{olBarplot}
\title{
Bar plot for intersect sets
}
\description{
Generates bar plots of the intersect counts of \code{VENNset} and
\code{INTERSECTset} objects generated by the \code{overLapper} function. It is
an alternative to Venn diagrames (e.g. \code{vennPlot}) that scales to larger numbers
of label sets. By default the bars in the plot are colored and grouped by complexity 
levels of the intersect sets. 
}
\usage{
olBarplot(x, mincount = 0, complexity="default", myxlabel = "default", myylabel="Counts", mytitle = "default", ...)
}
\arguments{
  \item{x}{
Object of class \code{VENNset} or \code{INTERSECTset}.
}
  \item{mincount}{
Sets minimum number of counts to consider in the bar plot. Default \code{mincount=0} 
considers all counts.
}
  \item{complexity}{
Allows user to limit the bar plot to specific complexity levels of intersects
by specifying the chosen ones with an integer vector. Default
\code{complexity="default"} considers all complexity levels. 
}
  \item{myxlabel}{
Defines label of x-axis.
}
  \item{myylabel}{
Defines label of y-axis.
}
  \item{mytitle}{
Defines main title of plot. 
}
  \item{\dots}{
Allows to pass on additional arguments to \code{geom_bar} from \code{ggplot2}.
For instance, \code{fill=seq(along=vennlist(x))} or
\code{fill=seq(along=intersectlist(x))} will assign a different color to each
bar, or \code{fill="blue"} will color all of them blue. The default bar
coloring is by complexity levels of the intersect sets.
}
}
\value{
Bar plot.
}
\author{
Thomas Girke
}
\note{
The functions provided here are an extension of the Venn diagram resources on this
site: http://manuals.bioinformatics.ucr.edu/home/R_BioCondManual#TOC-Venn-Diagrams
}

\seealso{
\code{overLapper}, \code{vennPlot}
}
\examples{
## Sample data: list of vectors with object labels
setlist <- list(A=sample(letters, 18), B=sample(letters, 16),
                C=sample(letters, 20), D=sample(letters, 22),
                E=sample(letters, 18), F=sample(letters, 22))

## 2-way Venn diagram
vennset <- overLapper(setlist[1:2], type="vennsets")
vennPlot(vennset)

## 3-way Venn diagram
vennset <- overLapper(setlist[1:3], type="vennsets")
vennPlot(vennset)

## 4-way Venn diagram
vennset <- overLapper(setlist[1:4], type="vennsets")
vennPlot(list(vennset, vennset))

## Pseudo 4-way Venn diagram with circles
vennPlot(vennset, type="circle")

## 5-way Venn diagram
vennset <- overLapper(setlist[1:5], type="vennsets")
vennPlot(vennset)

## Alternative Venn count input to vennPlot (not recommended!)
counts <- sapply(vennlist(vennset), length)
vennPlot(counts)

## 6-way Venn comparison as bar plot
vennset <- overLapper(setlist[1:6], type="vennsets")
olBarplot(vennset, mincount=1)

## Bar plot of standard intersect counts
interset <- overLapper(setlist, type="intersects")
olBarplot(interset, mincount=1)

## Accessor methods for VENNset/INTERSECTset objects
names(vennset)
names(interset)
setlist(vennset)
intersectmatrix(vennset)
complexitylevels(vennset)
vennlist(vennset)
intersectlist(interset)

## Coerce VENNset/INTERSECTset object to list
as.list(vennset)
as.list(interset)

## Pairwise intersect matrix and heatmap
olMA <- sapply(names(setlist), 
		function(x) sapply(names(setlist), 
		function(y) sum(setlist[[x]] \%in\% setlist[[y]])))
olMA
heatmap(olMA, Rowv=NA, Colv=NA)

## Presence-absence matrices for large numbers of sample sets
interset <- overLapper(setlist=setlist, type="intersects", complexity=2)
(paMA <- intersectmatrix(interset))
heatmap(paMA, Rowv=NA, Colv=NA, col=c("white", "gray")) 
}
\keyword{ utilities }
